---
title: Querying Magic Firewall Samples with GraphQL · Cloudflare Analytics docs
description: In this example, we are going to use the GraphQL Analytics API to
  query for Magic Firewall Samples over a specified time period.
lastUpdated: 2024-11-07T14:42:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/analytics/graphql-api/tutorials/querying-magic-firewall-samples/
  md: https://developers.cloudflare.com/analytics/graphql-api/tutorials/querying-magic-firewall-samples/index.md
---

In this example, we are going to use the GraphQL Analytics API to query for Magic Firewall Samples over a specified time period.

The following API call will request Magic Firewall Samples over a one hour period, and output the requested fields. Be sure to replace `<CLOUDFLARE_ACCOUNT_TAG>` and `<API_TOKEN>`[1](#user-content-fn-1) with your zone tag and API credentials, and adjust the `datetime_geg` and `datetime_leq` values to your liking.

## API Call

```bash
echo '{ "query":
  "query MFWActivity {
    viewer {
      accounts(filter: { accountTag: $accountTag }) {
        magicFirewallSamplesAdaptiveGroups(
          filter: $filter
          limit: 10
          orderBy: [datetimeFiveMinute_DESC]
        ) {
          sum {
            bits
            packets
          }
          dimensions {
            datetimeFiveMinute
            ruleId
          }
        }
      }
    }
  }",
  "variables": {
    "accountTag": "<CLOUDFLARE_ACCOUNT_TAG>",
    "filter": {
      "datetime_geq": "2022-07-24T11:00:00Z",
      "datetime_leq": "2022-07-24T11:10:00Z"
    }
  }
}' | tr -d '\n' | curl --silent \
https://api.cloudflare.com/client/v4/graphql \
--header "Authorization: Bearer <API_TOKEN>" \
--header "Accept: application/json" \
--header "Content-Type: application/json" \
--data @-
```

The returned values represent the total number of packets and bits received during the five minute interval for a particular rule. The result will be in JSON (as requested), so piping the output to `jq` will make it easier to read, like in the following example:

```bash
... | curl --silent \
https://api.cloudflare.com/client/v4/graphql \
--header "Authorization: Bearer <API_TOKEN>" \
--header "Accept: application/json" \
--header "Content-Type: application/json" \
--data @- | jq .


#=> {
#=>   "data": {
#=>     "viewer": {
#=>       "accounts": [
#=>         {
#=>           "magicFirewallSamplesAdaptiveGroups": [
#=>             {
#=>               sum: { bits:  327680, packets: 16384 },
#=>               dimensions: {
#=>                 datetimeFiveMinute: '2021-05-12T22:00-00:00',
#=>                 ruleId: 'bdfa8f8f0ae142b4a70ef15f6160e532'
#=>               }
#=>             },
#=>             {
#=>               sum: { bits:  360448, packets: 8192 },
#=>               dimensions: {
#=>                 datetimeFiveMinute: '2021-05-12T22:05-00:00',
#=>                 ruleId: 'bdfa8f8f0ae142b4a70ef15f6160e532'
#=>               }
#=>             },
#=>             {
#=>               sum: { bits:  327680, packets: 8192 },
#=>               dimensions: {
#=>                 datetimeFiveMinute: '2021-05-12T22:05-00:00',
#=>                 ruleId: 'bdfa8f8f0ae142b4a70ef15f6160e532'
#=>               }
#=>             },
#=>             {
#=>               sum: { bits:  360448, packets: 8192 },
#=>               dimensions: {
#=>                 datetimeFiveMinute: '2021-05-12T22:20-00:00',
#=>                 ruleId: 'bdfa8f8f0ae142b4a70ef15f6160e532'
#=>               }
#=>             },
#=>             {
#=>               sum: { bits:  327680, packets: 8192 },
#=>               dimensions: {
#=>                 datetimeFiveMinute: '2021-05-12T22:20-00:00',
#=>                 ruleId: 'bdfa8f8f0ae142b4a70ef15f6160e532'
#=>               }
#=>             }
#=>           ]
#=>         }
#=>       ]
#=>     }
#=>   },
#=>   "errors": null
#=> }
```

## Footnotes

1. Refer to [Configure an Analytics API token](https://developers.cloudflare.com/analytics/graphql-api/getting-started/authentication/api-token-auth/) for more information on configuration and permissions. [↩](#user-content-fnref-1)
