---
title: Local development support for Email Workers · Changelog
description: Developers can now use wrangler to do local development for Email Workers.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-04-08-local-development/
  md: https://developers.cloudflare.com/changelog/2025-04-08-local-development/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Local development support for Email Workers

Apr 08, 2025

[Email Routing](https://developers.cloudflare.com/email-routing/)

Email Workers enables developers to programmatically take action on anything that hits their email inbox. If you're building with Email Workers, you can now test the behavior of an Email Worker script, receiving, replying and sending emails in your local environment using `wrangler dev`.

Below is an example that shows you how you can receive messages using the `email()` handler and parse them using [postal-mime](https://www.npmjs.com/package/postal-mime):

```ts
import * as PostalMime from "postal-mime";


export default {
  async email(message, env, ctx) {
    const parser = new PostalMime.default();
    const rawEmail = new Response(message.raw);
    const email = await parser.parse(await rawEmail.arrayBuffer());
    console.log(email);
  },
};
```

Now when you run `npx wrangler dev`, wrangler will expose a local `/cdn-cgi/handler/email` endpoint that you can `POST` email messages to and trigger your Worker's `email()` handler:

```bash
curl -X POST 'http://localhost:8787/cdn-cgi/handler/email' \
  --url-query 'from=sender@example.com' \
  --url-query 'to=recipient@example.com' \
  --header 'Content-Type: application/json' \
  --data-raw 'Received: from smtp.example.com (127.0.0.1)
        by cloudflare-email.com (unknown) id 4fwwffRXOpyR
        for <recipient@example.com>; Tue, 27 Aug 2024 15:50:20 +0000
From: "John" <sender@example.com>
Reply-To: sender@example.com
To: recipient@example.com
Subject: Testing Email Workers Local Dev
Content-Type: text/html; charset="windows-1252"
X-Mailer: Curl
Date: Tue, 27 Aug 2024 08:49:44 -0700
Message-ID: <6114391943504294873000@ZSH-GHOSTTY>


Hi there'
```

This is what you get in the console:

```json
{
  "headers": [
    {
      "key": "received",
      "value": "from smtp.example.com (127.0.0.1) by cloudflare-email.com (unknown) id 4fwwffRXOpyR for <recipient@example.com>; Tue, 27 Aug 2024 15:50:20 +0000"
    },
    { "key": "from", "value": "\"John\" <sender@example.com>" },
    { "key": "reply-to", "value": "sender@example.com" },
    { "key": "to", "value": "recipient@example.com" },
    { "key": "subject", "value": "Testing Email Workers Local Dev" },
    { "key": "content-type", "value": "text/html; charset=\"windows-1252\"" },
    { "key": "x-mailer", "value": "Curl" },
    { "key": "date", "value": "Tue, 27 Aug 2024 08:49:44 -0700" },
    {
      "key": "message-id",
      "value": "<6114391943504294873000@ZSH-GHOSTTY>"
    }
  ],
  "from": { "address": "sender@example.com", "name": "John" },
  "to": [{ "address": "recipient@example.com", "name": "" }],
  "replyTo": [{ "address": "sender@example.com", "name": "" }],
  "subject": "Testing Email Workers Local Dev",
  "messageId": "<6114391943504294873000@ZSH-GHOSTTY>",
  "date": "2024-08-27T15:49:44.000Z",
  "html": "Hi there\n",
  "attachments": []
}
```

Local development is a critical part of the development flow, and also works for sending, replying and forwarding emails. See [our documentation](https://developers.cloudflare.com/email-routing/email-workers/local-development/) for more information.
