---
title: Publish messages to Queues directly via HTTP · Changelog
description: You can now publish messages to Cloudflare Queues from any HTTP client.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-05-09-publish-to-queues-via-http/
  md: https://developers.cloudflare.com/changelog/2025-05-09-publish-to-queues-via-http/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Publish messages to Queues directly via HTTP

May 09, 2025

[Queues](https://developers.cloudflare.com/queues/)

You can now publish messages to [Cloudflare Queues](https://developers.cloudflare.com/queues/) directly via HTTP from any service or programming language that supports sending HTTP requests. Previously, publishing to queues was only possible from within [Cloudflare Workers](https://developers.cloudflare.com/workers/). You can already consume from queues via Workers or [HTTP pull consumers](https://developers.cloudflare.com/queues/configuration/pull-consumers/), and now publishing is just as flexible.

Publishing via HTTP requires a [Cloudflare API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) with `Queues Edit` permissions for authentication. Here's a simple example:

```bash
curl "https://api.cloudflare.com/client/v4/accounts/<account_id>/queues/<queue_id>/messages" \
  -X POST \
  -H 'Authorization: Bearer <api_token>' \
  --data '{ "body": { "greeting": "hello", "timestamp":  "2025-07-24T12:00:00Z"} }'
```

You can also use our [SDKs](https://developers.cloudflare.com/fundamentals/api/reference/sdks/) for TypeScript, Python, and Go.

To get started with HTTP publishing, check out our [step-by-step example](https://developers.cloudflare.com/queues/examples/publish-to-a-queue-via-http/) and the full API documentation in our [API reference](https://developers.cloudflare.com/api/resources/queues/subresources/messages/methods/push/).
