---
title: Manage DNS records · Cloudflare DNS docs
description: Consider the sections below for step-by-step instructions on
  managing DNS records at Cloudflare.
lastUpdated: 2025-10-23T07:57:47.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/
  md: https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/index.md
---

Consider the sections below for step-by-step instructions on managing DNS records at Cloudflare.

To better understand what DNS records are, refer to [Overview](https://developers.cloudflare.com/dns/manage-dns-records/). For context around common records you want to review when getting started at Cloudflare, refer to [review DNS records](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/#review-dns-records).

Note

If your domain is added to Cloudflare by a hosting partner, manage your DNS records via the hosting partner.

## Create DNS records

* Dashboard

  To create a DNS record in the dashboard:

  1. In the Cloudflare dashboard, go to the **DNS Records** page.

     [Go to **Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records)

  2. Select **Add record**.

  3. Choose a record [**Type**](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/).

  4. Complete the required fields, which vary per record. Particularly important fields (for some records) include:

     * **Proxy status**: For `A`, `AAAA`, and `CNAME` records, decide whether hostname traffic is [proxied through Cloudflare](https://developers.cloudflare.com/dns/proxy-status/).
     * **TTL**: Short for [*Time to Live*](https://developers.cloudflare.com/dns/manage-dns-records/reference/ttl/), this field controls how long each record is valid and — as a result — how long it takes for record updates to reach your end users.
     * **Comment** and **Tag**: [Record attributes](https://developers.cloudflare.com/dns/manage-dns-records/reference/record-attributes/) meant for your reference.

  5. Select **Save**.

* API

  To create records with the API, use a [POST request](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/create/). For field definitions, select a record type under the request body specification.

  For specific API examples, refer to [DNS record types](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/).

***

## Edit DNS records

* Dashboard

  To edit DNS records in the dashboard:

  1. In the Cloudflare dashboard, go to the **DNS Records** page.

     [Go to **Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records)

  2. On a specific record, select **Edit**.

  3. Make any necessary changes.

  4. Select **Save**.

* API

  To update part of a record with the API, use a [PATCH request](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/edit/). If you want to overwrite the entire existing record, use a [PUT request](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/update/).

***

## Delete DNS records

* Dashboard

  To delete DNS records in the dashboard:

  1. In the Cloudflare dashboard, go to the **DNS Records** page.

     [Go to **Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records)

  2. On a specific record, select **Edit**.

  3. Select **Delete**.

  4. Select **Delete** again to confirm.

* API

  To delete records with the API, use a [DELETE request](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/delete/).

***

## Batch record changes

For guidance on how to apply several changes to your zone records in just one action, refer to [Batch record changes](https://developers.cloudflare.com/dns/manage-dns-records/how-to/batch-record-changes/).
