---
title: Device metrics · Cloudflare Magic WAN docs
description: Cloudflare customers can inspect metrics for a specific Magic WAN
  Connector in the Cloudflare dashboard. These metrics help you troubleshoot
  potential issues with your Magic WAN Connector. Refer to Troubleshooting for
  more information.
lastUpdated: 2025-11-04T17:07:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/configuration/connector/device-metrics/
  md: https://developers.cloudflare.com/magic-wan/configuration/connector/device-metrics/index.md
---

Cloudflare customers can inspect metrics for a specific Magic WAN Connector in the Cloudflare dashboard. These metrics help you troubleshoot potential issues with your Magic WAN Connector. Refer to [Troubleshooting](https://developers.cloudflare.com/magic-wan/configuration/connector/troubleshooting/) for more information.

## Query metrics with GraphQL

Customers can query Cloudflare's GraphQL API to fetch their Magic WAN Connector device metrics. The Cloudflare dashboard displays Magic WAN Connector device metrics over the past one hour. Via the GraphQL API, customers can query for up to 30 days of historical Magic WAN Connector device metrics.

For example:

```graphql
query telemetry(
  $accountTag: string
  $snapshotsFilter: AccountMconnTelemetrySnapshotsAdaptiveGroupsFilter_InputObject!
  $snapshotMountsFilter: AccountMconnTelemetrySnapshotMountsAdaptiveGroupsFilter_InputObject!
  $snapshotThermalsFilter: AccountMconnTelemetrySnapshotThermalsAdaptiveGroupsFilter_InputObject!
  $limit: int64!
) {
  viewer {
    accounts(filter: { accountTag: $accountTag }) {
      snapshots: mconnTelemetrySnapshots(
        filter: $snapshotsFilter
        limit: $limit
        orderBy: [datetimeFiveMinutes_DESC]
      ) {
        max {
          cpuCount
          loadAverage1m
          memoryFreeBytes
          memoryTotalBytes
        }
        dimensions {
          connectorId
          datetimeFiveMinutes
        }
      }
      snapshotMounts: mconnTelemetrySnapshotMounts(
        filter: $snapshotMountsFilter
        limit: $limit
        orderBy: [datetimeFiveMinutes_DESC]
      ) {
        max {
          availableBytes
          totalBytes
        }
        dimensions {
          connectorId
          datetimeFiveMinutes
        }
      }
      snapshotThermals: mconnTelemetrySnapshotThermals(
        filter: $snapshotThermalsFilter
        limit: $limit
        orderBy: [datetimeFiveMinutes_DESC, connectorId_DESC]
      ) {
        max {
          currentCelcius
        }
        dimensions {
          connectorId
          datetimeFiveMinutes
        }
      }
    }
  }
}
```

[Run in GraphQL API Explorer](https://graphql.cloudflare.com/explorer?query=I4VwpgTgngBALmANmAtmO0AUAoGMAkAhgMbED2IAdnACqEDmAXDAM4YCWl9uBLlhABxYALMnBYAxdogQRmAQVIVqAWXKVKNJKnTQAyvyGjx8gCaC47AG5gA4hApCpMyAH0AkpQEg4AeQBGAFZgxHAAhDz4fIIiYirK4s6yCkpUcGpkGlrIaBhQBjHG8WksZhbWdg4gTtKyHl4+AcGhEXhRhrG0wpAohIiStZAp5GkZWdq5+h3GNN0Qvf1lApY29o4DLhD13n5BIeGRiOwo7HDMnHAAbAAsEQCUMADePFbsYADukE88eCQj1CxMAAzQZyJ4wP4JOhMAiQtLQmAAXwezzwaNY0zELGYKHUmgmunymPEOHR6JBm2Y7UKWKSkB+ZKOJzOBCZpwZ6LIEFMkAAQlBmABtcwISxoKQ2FScHxgFiuAAiAFE9ABhAC6HJgKM1eF6AA9vmSycRvCqEjq0YgyIRTPIbBAGGAAIwoC261BcqASCBgMD8hAsN0wNAoT00MR9f2yi2Ii2mY5gSgsdiZFiGo1ovH7LnuUxBkXoBMSsBSygywMZpGa2NG6JGOIJbHBvHZHR5Ar19KN0kZinJXjE4oAukQC1sln4ccWrk8iD8oUFsVgYul8sK5XqzXayv69OVwhWQjSQj+ZBRiuV+ARxDnmNxhNJlNJvcZrOhHN5y8wRdFiqrgN3kaNZknWnSzD0fRNrimT4jkhIdmBcwLICFp9kMA40l0EH9COY7HKcVJTpWM58gKMDCoQoq-pK0oBuuqoADQwG+cAfvRm5GtuGa7qil7ECAEA+tQKpIMQ7AgBeQH3mgj6pi+RosR++aUYW4p-rR0aVsB6LaVWeCxoiQA\&variables=N4IghgxhD2CuB2AXAKmA5iAXCAggYTwHkBVAOWQH0BJAERABoQAbASwFsXEsBGABl4C+QA)

### Average CPU load explained

The metric `average CPU load` is unique and distinctly different from `CPU utilization` which is another common CPU metric. The Magic WAN Connector uses a [Unix-style CPU load calculation](https://en.wikipedia.org/wiki/Load_\(computing\)).

CPU load is a measure of the number of processes that are currently running and that are waiting to be run on the CPU. Cloudflare collects the one minute load average from the device and converts that into a percentage based on the total number of cores in the CPU. If the Magic WAN Connector CPU has eight cores, and a one minute load average of two, then the average CPU load is 25%. If the average CPU load is above 100%, then there are processes in the queue that are waiting to be executed on the CPU.

Cloudflare is still evaluating the typical CPU load operating range on the Magic WAN Connector. In general, a healthy range for average CPU load on any device is between 30% and 70%. Customers may experience decreased Magic WAN Connector performance if the average CPU load is consistently above 100%.
