---
title: Mathematical operations · Cloudflare Style Guide
description: Expressions that show how to make a particular calculation.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/mathematical-operations/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/mathematical-operations/index.md
---

## Definition

Expressions that show how to make a particular calculation.

## Used in

[How to](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/how-to/), [Reference](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/reference/), [Tutorial](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/tutorial/)

## Structure

If an operation occurs inside of a code block, use the formatting associated with that programming language. If an operation occurs in text, either leave the equation in plain text with spaces between operators for readability or use math typesetting.

## Example

| Correct | Incorrect |
| - | - |
| 25 / 30 | 25/30 |
| `𝑒(𝑎𝑃,𝑏𝑄)=𝑒(𝑃,𝑄)𝑎𝑏` | e(aP,bQ)=e(P,Q)ab |
