---
title: Triggers and rules · Cloudflare Zaraz docs
description: Triggers define the conditions under which a tool will start an
  action. In most cases, your objective will be to create triggers that match
  specific website events that are relevant to your business. A trigger can be
  based on an event that happened on your website, like after selecting a button
  or loading a specific page.
lastUpdated: 2024-09-24T17:04:21.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/zaraz/reference/triggers/
  md: https://developers.cloudflare.com/zaraz/reference/triggers/index.md
---

Triggers define the conditions under which [a tool will start an action](https://developers.cloudflare.com/zaraz/custom-actions/). In most cases, your objective will be to create triggers that match specific website events that are relevant to your business. A trigger can be based on an event that happened on your website, like after selecting a button or loading a specific page.

These website events can be passed to Cloudflare Zaraz in a number of ways. You can use the [Track](https://developers.cloudflare.com/zaraz/web-api/track/) method of the Web API or the [`dataLayer`](https://developers.cloudflare.com/zaraz/advanced/datalayer-compatibility/) call. Alternatively, if you do not want to write code to track events on your website, you can configure triggers to listen to browser-side website events, with different types of rules like click listeners or form submissions.

## Rule types

The exact composition of the trigger will change depending on the type of rule you choose.

### Match rule

Zaraz matches the variable you input in **Variable name** with the text under **Match string**. For a complete list of supported variables, refer to [Properties reference](https://developers.cloudflare.com/zaraz/reference/properties-reference/).

**Trigger example: Match `zaraz.track("purchase")`**

| Rule type | Variable name | Match operation | Match string |
| - | - | - | - |
| *Match rule* | *Event Name* | *Equals* | `purchase` |

If you create a trigger with match rules using variables from Page Properties, Cookies, Device Properties, or Miscellaneous categories, you will often want to add a second rule that matches `Pageview`. Otherwise, your trigger will be valid for every other event happening on this page too. Refer to [Create a trigger](https://developers.cloudflare.com/zaraz/custom-actions/create-trigger/) to learn how to add more than one condition to a trigger.

**Trigger example: All pages under `/blog`**

| Rule type | Variable name | Match operation | Match string |
| - | - | - | - |
| *Match rule* | *URL pathname* | *Starts with* | `/blog` |

| Rule type | Variable name | Match operation | Match string |
| - | - | - | - |
| *Match rule* | *Event Name* | *Equals* | `Pageview` |

**Trigger example: All logged in users**

| Rule type | Variable name | Match operation | Match string |
| - | - | - | - |
| *Match rule* | *Cookie: name:* `isLoggedIn` | *Equals* | `true` |

| Rule type | Variable name | Match operation | Match string |
| - | - | - | - |
| *Match rule* | *Event Name* | *Equals* | `Pageview` |

Refer to [Properties reference](https://developers.cloudflare.com/zaraz/reference/properties-reference/) for more information on the variables you can use when using Match rule.

### Click listener

Tracks clicks in a web page. You can set up click listeners using CSS selectors or XPath expressions. **Wait for actions** (in milliseconds) tells Zaraz to prevent the page from changing for the amount of time specified. This allows all requests triggered by the click listener to reach their destination.

Note

When using CSS type rules in triggers, you have to include the CSS selector — for example, the ID (`#`) or the class (`.`) symbols. Otherwise, the click listener will not work.

**Trigger example for CSS selector:**

| Rule type | Type | Selector | Wait for actions |
| - | - | - | - |
| *Click listener* | *CSS* | `#my-button` | `500` |

To improve the performance of the web page, you can limit a click listener to a specific URL, by combining it with a Match rule. For example, to track button clicks on a specific page you can set up the following rules in a trigger:

| Rule type | Type | Selector | Wait for actions |
| - | - | - | - |
| *Click listener* | *CSS* | `#myButton` | `500` |

| Rule type | Variable name | Match operation | Match string |
| - | - | - | - |
| *Match rule* | *URL pathname* | *Equals* | `/my-page-path` |

If you need to track a link of an element using CSS selectors - for example, on a clickable button - you have to create a listener for the `href` attribute of the `<a>` tag:

| Rule type | Type | Selector | Wait for actions |
| - | - | - | - |
| *Click listener* | *CSS* | `a[href$='/#my-css-selector']` | `500` |

Refer to [**Create a trigger**](https://developers.cloudflare.com/zaraz/custom-actions/create-trigger/) to learn how to add more than one rule to a trigger.

***

**Trigger example for XPath:**

| Rule type | Type | Selector | Wait for actions |
| - | - | - | - |
| *Click listener* | *XPath* | `/html/body//*[contains(text(), 'Add To Cart')]` | `500` |

### Element Visibility

Triggers an action when a CSS selector becomes visible in the screen.

| Rule type | CSS Selector |
| - | - |
| *Element Visibility* | `#my-id` |

### Scroll depth

Triggers an action when the users scrolls a predetermined amount of pixels. This can be a fixed amount of pixels or a percentage of the screen.

**Example with pixels**

| Rule type | CSS Selector |
| - | - |
| *Scroll Depth* | `100px` |

***

**Example with a percentage of the screen**

| Rule type | CSS Selector |
| - | - |
| *Scroll Depth* | `45%` |

### Form submission

Tracks form submissions using CSS selectors. Select the **Validate** toggle button to only fire the trigger when the form has no validation errors.

**Trigger example:**

| Rule type | CSS Selector | Validate |
| - | - | - |
| *Form submission* | `#my-form` | Toggle on or off |

To improve the performance of the web page, you can limit a Form submission trigger to a specific URL, by combining it with a Match rule. For example, to track a form on a specific page you can set up the following rules in a trigger:

| Rule type | CSS Selector | Validate |
| - | - | - |
| *Form submission* | `#my-form` | Toggle on or off |

| Rule type | Variable name | Match operation | Match string |
| - | - | - | - |
| *Match rule* | *URL pathname* | *Equals* | `/my-page-path` |

Refer to [**Create a trigger**](https://developers.cloudflare.com/zaraz/custom-actions/create-trigger/) to learn how to add more than one condition to a trigger.

### Timer

Set up a timer that will fire the trigger after each **Interval**. Set your interval time in milliseconds. In **Limit** specify the number of times the interval will run, causing the trigger to fire. If you do not specify a limit, the timer will repeat for as long as the page is on display.

**Trigger example:**

| Rule type | Interval | Limit |
| - | - | - |
| *Timer* | `5000` | `1` |

The above Timer will fire once, after five seconds. To improve the performance of a web page, you can limit a Timer trigger to a specific URL, by combining it with a Match rule. For example, to set up a timer on a specific page you can set up the following rules in a trigger:

| Rule type | Interval | Limit |
| - | - | - |
| *Timer* | `5000` | `1` |

| Rule type | Variable name | Match operation | Match string |
| - | - | - | - |
| *Match rule* | *URL pathname* | *Equals* | `/my-page-path` |

Refer to [**Create a trigger**](https://developers.cloudflare.com/zaraz/custom-actions/create-trigger/) to learn how to add more than one condition to a trigger.
